////////////////////////////////////////////////////////
//
// AcctMgrDBUtils.java
//
package Alkindi.Services.ServicesImpl;

import java.sql.*;
import oracle.jdbc.driver.*;
import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.Util.*;
import Alkindi.Services.InternalData.*;

/* 
$Header: AcctMgrDBUtils.java, 21, 4/26/01 2:37:14 PM, Schwartz, Joe$
$Log: 
 21   Alkindi Development1.20        4/26/01 2:37:14 PM   Schwartz, Joe  
      Modifed to account for new InternalData package.
 20   Alkindi Development1.19        4/26/01 1:11:03 PM   Schwartz, Joe   Moved
      into new ServicesImpl package.
 19   Alkindi Development1.18        12/28/00 1:47:10 PM  Schwartz, Joe  
      Replaced missing methods and other errors due to Rose import. 
 18   Alkindi Development1.17        12/28/00 1:08:39 PM  Schwartz, Joe   Added
      Version Control header info.

 17   Alkindi Development1.16        12/26/00 6:57:09 PM  Schwartz, Joe   
 16   Alkindi Development1.15        12/26/00 5:36:57 PM  Schwartz, Joe   
 15   Alkindi Development1.14        12/18/00 12:05:34 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 14   Alkindi Development1.13        12/18/00 11:26:50 AM Schwartz, Joe   
 13   Alkindi Development1.12        12/6/00 7:11:59 PM   Schwartz, Joe   Added
      catch blocks for generic exceptions and finally blocks to close all
      database connections.
 12   Alkindi Development1.11        12/4/00 3:21:17 PM   Schwartz, Joe   Fixes
      for SQL exception in getUserDetailsList: illegal column name. Changed to
      use column number.
 11   Alkindi Development1.10        12/4/00 1:01:06 PM   Schwartz, Joe  
      Removed connection.close() call from getUserDetailList()
 10   Alkindi Development1.9         12/4/00 12:54:48 PM  Schwartz, Joe   Added
      connection.close() call to getUserDetailsList()
 9    Alkindi Development1.8         12/3/00 6:29:40 PM   Stanton, Sacha  
 8    Alkindi Development1.7         11/18/00 9:27:51 PM  Schwartz, Joe   
 7    Alkindi Development1.6         11/14/00 12:53:16 PM Schwartz, Joe   
 6    Alkindi Development1.5         11/2/00 12:31:10 PM  Schwartz, Joe  
      Chagned to use new procs for USER_PREFERRED_CATEGORY table.
 5    Alkindi Development1.4         11/1/00 4:57:28 PM   Schwartz, Joe  
      Modified to reflect change in dB: REL_USER_MOVE_GENRE dropped and replaced
      with USER_PREFERRED_CATEGORY
 4    Alkindi Development1.3         10/22/00 10:38:48 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 3    Alkindi Development1.2         10/17/00 2:22:49 PM  Schwartz, Joe  
      Delivery 10.16.00
 2    Alkindi Development1.1         10/7/00 4:34:33 PM   Schwartz, Joe   
 1    Alkindi Development1.0         10/7/00 4:29:10 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 */
public class AcctMgrDBUtils 
{
	protected final String cName = "AcctMgrDBUtils";
	
	/**
	 * @roseuid 3A4B660D0280
	 */
	public void updateUserActivity(java.sql.Connection con, SystemUser su, UserDetailList AL) throws AlkExcept 
	{
		final String mName = "updateUserActivity";
		String errmsg = "";
		try {
			updateUserDetail(con, su, AL, "{ call pkg_ALKINDI_USER.sp_DEL_USER_ACTIVITY(?,?) }", "{ call pkg_ALKINDI_USER.sp_INS_USER_ACTIVITY(?,?) }");
		}

		catch(SQLException se) {
			errmsg = "SQL Exception: " + se.getMessage();
			throw new AlkExcept(errmsg + " in " + mName, 2420);
		}
		catch (Exception e) {
			throw new AlkExcept(e.getMessage() + " in " + mName, 2420);
		}
	}
	
	/**
	 * @roseuid 3A4B660D029F
	 */
	public void updateUserGenre(java.sql.Connection con, SystemUser su, UserDetailList GL) throws AlkExcept 
	{
		final String mName = "updateUserGenre";
		try {
			updateUserDetail(con, su, GL, "{ call pkg_ALKINDI_USER.sp_DEL_USER_PREFERRED_CATEGORY(?,?) }", "{ call pkg_ALKINDI_USER.sp_INS_USER_PREFERRED_CATEGORY(?,?) }");
		}

		catch(SQLException se) {
			throw new AlkExcept(se.getMessage(), 2420);
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage() + " in " + mName, 2420);
		}
	}
	
	/**
	 * @roseuid 3A4B660D02BF
	 */
	public void updateUserInterest(java.sql.Connection con, SystemUser su, UserDetailList IL) throws AlkExcept 
	{

		try {
			updateUserDetail(con, su, IL, "{ call pkg_ALKINDI_USER.sp_DEL_USER_INTEREST(?,?) }", "{ call pkg_ALKINDI_USER.sp_INS_USER_INTEREST(?,?) }");
		}

		catch(SQLException se) {
			throw new AlkExcept(se.getMessage(), 2420);
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2420);
		}
	}
	
	/**
	 * @roseuid 3A4B660D02CF
	 */
	public void updateUserLanguage(java.sql.Connection con, SystemUser su, UserDetailList LL) throws AlkExcept 
	{

		try {
			updateUserDetail(con, su, LL, "{ call pkg_ALKINDI_USER.sp_DEL_USER_LANGUAGE(?,?) }", "{ call pkg_ALKINDI_USER.sp_INS_USER_LANGUAGE(?,?) }");
		}

		catch(SQLException se) {
			throw new AlkExcept(se.getMessage(), 6004);
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2420);
		}
	}
	
	/**
	 * @roseuid 3A4B660D02EF
	 */
	public void updateUserProfession(java.sql.Connection con, SystemUser su, UserDetailList PL) throws AlkExcept 
	{

		try {
			updateUserDetail(con, su, PL, "{ call pkg_ALKINDI_USER.sp_DEL_USER_PROFESSION(?,?) }", "{ call pkg_ALKINDI_USER.sp_INS_USER_PROFESSION(?,?) }");
		}

		catch(SQLException se) {
			throw new AlkExcept(se.getMessage(), 2420);
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2420);
		}
	}
	
	/**
	 * @roseuid 3A4B660D030E
	 */
	public void updateUserSport(java.sql.Connection con, SystemUser su, UserDetailList SL) throws AlkExcept 
	{

		try {
			updateUserDetail(con, su, SL, "{ call pkg_ALKINDI_USER.sp_DEL_USER_SPORTS(?,?) }", "{ call pkg_ALKINDI_USER.sp_INS_USER_SPORTS(?,?) }");
		}

		catch(SQLException se) {
			throw new AlkExcept(se.getMessage(), 2420);
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2420);
		}
	}
	
	/**
	 * @roseuid 3A4B660D032D
	 */
	public void updateUserDetail(java.sql.Connection con, SystemUser su, UserDetailList list, String deleteSP, String insertSP) throws SQLException,AlkExcept 
	{
		try {
			CallableStatement csDel = con.prepareCall(deleteSP);
			csDel.setLong(1, su.id);

			System.out.println("su="+su.id+"   delsp:"+deleteSP);

			csDel.registerOutParameter(2, Types.INTEGER);
			csDel.execute();
			int rc = csDel.getInt(2);
			csDel.close();
			if (rc != 0) {
				throw new AlkExcept("", rc);
			}

			if (list.size() > 0) {
				CallableStatement csIns = con.prepareCall(insertSP);
				for (int idx = 0; idx < list.size(); idx ++) {
					csIns.setLong(1, su.id);
					csIns.setLong(2, list.get(idx).id);
	//		System.out.println("su="+su.id+"   ins-sp: idx:"+ list.get(idx).id);
					csIns.execute();
				}

				csIns.close();
			}
		}
		catch(SQLException se) {
			throw se;
		}
		catch(AlkExcept ae) {
			throw ae;
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2420);
		}
	}
	
	/**
	 * @roseuid 3A4B660D036B
	 */
	public UserDetailList getUserDetailList(java.sql.Connection con, SystemUser su, String getDetailSP, String detailID, String errCName, String errMName) throws SQLException,AlkExcept 
	{
		ResultSet rs = null;
		CallableStatement cs = null;
		UserDetailList sl = null;
		try {
			String errmsg = "";
			cs = con.prepareCall(getDetailSP);

			sl = new UserDetailList();

			cs.setLong (1,su.id);

			cs.registerOutParameter(2,OracleTypes.CURSOR);
			cs.registerOutParameter(3,Types.INTEGER);

			cs.execute();

			rs = ((OracleCallableStatement)cs).getCursor(2);

			int error = cs.getInt(3);

			switch (error){

			case 0:
					while (rs.next()) {
						sl.add(new UserDetailItem(rs.getInt(1)));
					}
					break;
			case 654:
				errmsg = "Error in" + getDetailSP;
				throw new AlkExcept(errmsg, 6549);

			case 6550:
				errmsg = "Error in" + getDetailSP;
				throw new AlkExcept(errmsg, 6550);

			case 6548:
				errmsg = "Error in" + getDetailSP;
				throw new AlkExcept(errmsg, 6548);

			case 6547:
				errmsg = "Error in" + getDetailSP;
				throw new AlkExcept(errmsg, 6547);

			case 6551:
				errmsg = "Error in" + getDetailSP;
				throw new AlkExcept(errmsg, 6551);

			case 6546:
				errmsg = "Error in" + getDetailSP;
				throw new AlkExcept(errmsg, 6546);

			}
		}
		catch (AlkExcept ae) {
			throw ae;
		}
		catch(SQLException se) {
			throw se;
		}
		catch(Exception e) {
			throw new AlkExcept(e.getMessage(), 2420);
		}
		finally {
			try {
				if (rs != null) 
					rs.close();
				if (cs != null) 
					cs.close();
			}
			catch (Exception e) {
			}
		}
		return sl;
	}
}
